import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a new figure and axis
fig, ax = plt.subplots(figsize=(10, 12))

# Define colors for tiles and robots
colors = {
    'clear': 'green',
    'occupied': 'red',
    'painted': 'gray',
    'robot_white': 'white',
    'robot_black': 'black'
}

# Define the grid size
rows, cols = 5, 4

# Add tiles to the plot
tile_size = 1
for row in range(rows):
    for col in range(cols):
        tile_id = f"tile_{row}-{col+1}"
        if (row, col) in [(1, 0), (1, 1)]:  # Occupied tiles by robots
            color = colors['occupied']
        else:
            color = colors['clear']
        rect = patches.Rectangle((col, rows-row-1), tile_size, tile_size, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black', fontweight='bold')

# Add robots to the plot
robots = {
    'robot1': (1, 0, 'robot_white'),
    'robot2': (1, 1, 'robot_black')
}

for robot, (row, col, color_key) in robots.items():
    circle = patches.Circle((col + 0.5, rows-row-1 + 0.5), 0.3, linewidth=1, edgecolor='black', facecolor=colors[color_key])
    ax.add_patch(circle)
    ax.text(col + 0.5, rows-row-1 + 0.5, robot, ha='center', va='center', fontsize=8, color='black', fontweight='bold')

# Add available colors
available_colors = [('color_white', 'white'), ('color_black', 'black')]
for i, (color_name, color) in enumerate(available_colors):
    rect = patches.Rectangle((cols + 1, rows - i - 1), tile_size, tile_size/2, linewidth=1, edgecolor='black', facecolor=color)
    ax.add_patch(rect)
    ax.text(cols + 1.5, rows - i - 1 + tile_size/4, color_name, ha='center', va='center', fontsize=8, color='black', fontweight='bold')

# Add legend
legend_elements = [
    patches.Patch(facecolor=colors['clear'], edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=colors['occupied'], edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor=colors['painted'], edgecolor='black', label='Painted Tile'),
    patches.Patch(facecolor=colors['robot_white'], edgecolor='black', label='Robot Holding White'),
    patches.Patch(facecolor=colors['robot_black'], edgecolor='black', label='Robot Holding Black')
]
ax.legend(handles=legend_elements, loc='upper left', bbox_to_anchor=(1.05, 1), borderaxespad=0.)

# Set limits and hide axes
ax.set_xlim(-0.5, cols + 2.5)
ax.set_ylim(-0.5, rows)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_39.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# The legend overlaps with the grid, and the text labels on the robots are not fully readable.
